<?php
/******	THIS SECTION SHOULD BE CUSTOMISED BY YOU TO REFLECT YOUR SITE		***********/
$template = "hws.php";           //this is the page where the results will be displayed
                                    //this page must contain this "<!--DOMAIN RESULTS-->"
                                    //where ever you want the results to be displayed

$registerlink = "redirect.php";       //this is the page a user is taken to if they want to
                                    //register the domain name from you or your affiliate
                                    //it should be a script preferably because this script
                                    //will pass it the $domain variable using the get method
                                    //for example signup.php?domain=topdog-software.com
                                    
$restrict = 0;                      //set to 0 if you don't want to restrict access
                                    //set to 1 if you want to restrict access remember to
                                    //change $REFERERS below to reflect your site.

//$REFERERS = array('topdog-software.com', 'www.topdog-software.com');
                                    //These are the domains allowed to access the script
                                    //if you decide to restrict access
error_reporting(0);
/************************	END CUSTOMISATIONS	************************************/

/************************	SERVER DEFINITIONS	************************************/
$serverdefs= array(
						"com" => array("whois.crsnic.net","No match for"),
						"net" => array("whois.crsnic.net","No match for"),				
						"org" => array("whois.pir.org","NOT FOUND"),					
						"biz" => array("whois.biz","Not found"),					
						"info" => array("whois.afilias.net","NOT FOUND"),
						"in" => array("whois.inregistry.net","NOT FOUND"),
						"asia" => array("whois.nic.asia","NOT FOUND"),
						"mobi" => array("whois.dotmobiregistry.net","NOT FOUND"),
						"co.in" => array("whois.inregistry.net","NOT FOUND"),
						"name" => array("whois.nic.name","No match"),					
						"co.uk" => array("whois.nic.uk","No match"),					
						"co.ug" => array("wawa.eahd.or.ug","No entries found"),	
						"or.ug" => array("wawa.eahd.or.ug","No entries found"),
						"ac.ug" => array("wawa.eahd.or.ug","No entries found"),
						"ne.ug" => array("wawa.eahd.or.ug","No entries found"),
						"sc.ug" => array("wawa.eahd.or.ug","No entries found"),
						"nl" 	=> array("whois.domain-registry.nl","not a registered domain"),
						"ro" => array("whois.rotld.ro","No entries found for the selected"),
						"com.au" => array("whois.ausregistry.net.au","No data Found"),
						"ca" => array("whois.cira.ca", "AVAIL"),
						"org.uk" => array("whois.nic.uk","No match"),
						"us" => array("whois.nic.us","Not Found"),
						"ws" => array("whois.website.ws","No Match"),
						"be" => array("whois.ripe.net","No entries"),
						"com.cn" => array("whois.cnnic.cn","no matching record"),
						"net.cn" => array("whois.cnnic.cn","no matching record"),
						"org.cn" => array("whois.cnnic.cn","no matching record"),
						"no" => array("whois.norid.no","no matches"),
						"se" => array("whois.nic-se.se","No data found"),
						"nu" => array("whois.nic.nu","NO MATCH for"),
						"com.tw" => array("whois.twnic.net","No such Domain Name"),
						"net.tw" => array("whois.twnic.net","No such Domain Name"),
						"org.tw" => array("whois.twnic.net","No such Domain Name"),
						"cc" => array("whois.nic.cc","No match"),
						"nl" => array("whois.domain-registry.nl","is free"),
						"pl" => array("whois.dns.pl","No information about"),
						"pt" => array("whois.ripe.net","No entries found"),
						"de" => array("whois.denic.de","not found in database"),
                        "eu" => array("whois.eu","FREE"),
                        "za.org" => array("whois.za.net","No such domain"),
                        "za.net" => array("whois.za.net","No such domain"),
                        "tv" => array("tvwhois.verisign-grs.com","No match for")



					);
/*********************** 	END SERVER DEFINITIONS	*********************************/


if ($_SERVER['REQUEST_METHOD'] == 'GET'){
    $domain = htmlspecialchars($_GET['domain']);
    $ext = htmlspecialchars($_GET['ext']);
    $option = htmlspecialchars($_GET['option']);
}else{
    $domain = htmlspecialchars($_POST['domain']);
    $ext = htmlspecialchars($_POST['ext']);
    $option = htmlspecialchars($_POST['option']);
}

if($restrict ==1){
    check_referer();
}
/************* 	Perform checks domain x-ters			*************************************/
namecheck($domain);

/*************		Check domain zone					************************************/
	if ($serverdefs[$ext]){
	    $server = $serverdefs[$ext][0];
	    $nomatch = $serverdefs[$ext][1];
	    if($option=="check")
	    {
	        $layout = check_domain($domain,$ext);
	        print_results($layout);
	    }
	    if($option=="whois")
	    {
	        whois($domain,$ext);
	    }
    }
    elseif($ext == "co.za"){
    	if($option == "check"){
    	   if(function_exists(curl_init)){
					$layout = cozacurlcheck($domain);
			}else{
					$layout = cozacheck($domain);
			}
			print_results($layout);
		}elseif($option=="whois"){
			if(function_exists(curl_init)){
				cozacurlwhois($domain);
			}else{
				cozawhois($domain);
			}
		}
    }
    elseif($ext == "all"){
	    $layout = "<tr>\n<td>\n<table width=\"100%\" border=\"0\" cellPadding=2 class=font1l>\n";
	    foreach($serverdefs as $ext => $servers)
	    {
		    $server = $servers[0];
		    $nomatch = $servers[1];
		    $available = check_domain($domain, $ext);
		    if ($available == 0)
		    {
			    $layout .= sprintf("<tr>\n<td>\n%s.%s</td>\n<td align=center>\n<font color=\"green\">\n<b>Available!</b>\n</font>\n</td>\n", $domain, $ext);
			    $layout .= sprintf("<td>\n<a href=\"%s?domain=%s.%s\">register now</a>\n</td>\n</tr>\n", $registerlink, $domain, $ext);
			}
			elseif ($available == 2)
		    {
			    $layout .= sprintf("<tr>\n<td>\n%s.%s</td>\n<td>\n<font color=\"grey\">\nUnknown</font>\n</td>\n", $domain, $ext);
			    $layout .= "<td>\nCould not contact server</td>\n</tr>\n";
			}
			else
			{
				$layout .= sprintf("\n<tr>\n<td>\n%s.%s</td>\n<td>\n<font color=\"red\">Taken\n</font>\n</td>\n", $domain, $ext);
			   $layout .= sprintf("<td>\n<a href=\"%s?domain=%s&ext=%s&option=whois\">check whois</a></td>\n</tr>\n", $PHP_SELF, $domain, $ext);
		   }
	    }
	    $layout .= "</table>\n</td>\n</tr>\n";
	    $ext = " all supported domains";
	    print_results($layout);
	}

/**	<------------------------------------functions--------------------------------> **/
function check_domain($domain,$ext)
{
    global $nomatch,$server;
    $output="";
    if(($sc = fsockopen($server,43))==false){return 2;}
    if($ext == "co.uk")
           fputs($sc,"$domain.$ext\r\n");
    elseif($ext == "nl") 
	   fputs($sc, "is $domain.$ext\r\n");
    else
           fputs($sc,"$domain.$ext\n");

    while(!feof($sc)){$output.=fgets($sc,128);}
    fclose($sc);
    //compare what has been returned by the server
    if (eregi($nomatch,$output)){
		return 0;
    }else{
        return 1;
    }
}

/*********		Function to return whois results		***********************************/
function whois($domain,$ext)
{   global $template,$server;
    if(($sc = fsockopen($server,43))==false){
        if(($sc = fsockopen($server,43))==false){
            //echo"There is a temporary service disruption Please again try later";
            $layout =2;
            print_results($layout);
            exit;
        }
    }
    if($ext=="com"||$ext=="net"){
        //
        fputs($sc, "$domain.$ext\n");
        while(!feof($sc)){
            $temp = fgets($sc,128);
            if(ereg("Whois Server:", $temp)) {
                $server = str_replace("Whois Server: ", "", $temp);
                $server = trim($server);
            }
        }
        fclose($sc);
        if(($sc = fsockopen($server,43))==false){
            //echo"There is a temporary service disruption Please try later";
            $layout =2;
            print_results($layout);
            exit;
        }
    }

    $output="";
    if($ext == "co.uk")
	fputs($sc,"$domain.$ext\r\n");
    else
	fputs($sc,"$domain.$ext\n");

    while(!feof($sc)){$output.=fgets($sc,128);}
    fclose($sc);
    //print
	print_whois($output);
    

}
/*******		function to check referer	************************************************/
function check_referer () {
	global $REFERERS, $HTTP_REFERER;
	if ($HTTP_REFERER != "")
		while (list($val, $ref) = each($REFERERS))
		if (preg_match("/^http:\/\/$ref/", $HTTP_REFERER))
		return;
		exit;
}
/*******		Function to print the results into your template	************************/
function print_results($layout)
{
    global $template,$registerlink,$domain,$ext,$server;
    if(!is_file($template)){
        print"The template file into which to print the results either does not exist or is
        not writeable<br>
        please correct this if you are the webmaster of this site<br>
        The script can not continue exiting......";
        exit;
    }
			
    $template = file ($template);
    $numtlines = count ($template);	//Number of lines in the template
    $line = 0;
    while (! stristr ($template[$line], "<!--HEAVENS DOMAIN RESULTS-->") && $line < $numtlines) {
	echo $template[$line];
	$line++;
    }
    if($layout=="0"){
        $line++;
        	
        	print   "<tr><td><b><center>Domain Search Results for \"$domain.$ext\"</b></td></tr>";
        	print   "<tr><td><hr></td></tr>";
        	print   "<tr><td align=\"center\"><img src=\"images\heavenstick.png\" \><font size=\"4\"> Congratulations <font color=#2F4CFC> $domain.$ext</font> is available. <!--register it now--></font></td></tr>";
        	print   "<tr><td align=\"center\">&nbsp;</td></tr>";
			

print   "<tr><td align=\"center\"><INPUT TYPE=\"BUTTON\" VALUE=\"Click here to Register\" class=\"btn\" ONCLICK=\"window.location.href='$registerlink?pid=1&domain=$domain&domain2=$ext&domainexist=no'\"></FORM></td></tr>";
    		print   "</table>";
	}
    elseif($layout=="1"){
        $line++;
        	print   "<table width=\"100%\" border=\"0\" cellPadding=2 class=font1l>\n";
        	print 	"<tr>\n<td>\n<b>\n<center>Domain Search Results for \"$domain.$ext\"</b>\n<br>\n</td>\n</tr>\n";
        	print   "<tr>\n<td>\n<hr>\n</td>\n</tr>\n";
        	print   "<tr>\n<td>\n<b>\n<font size=4><center>Sorry <font color=red>www.$domain.$ext</font> is already taken <a href=\"$PHP_SELF?domain=$domain&ext=$ext&option=whois\" TARGET=\"_blank\"><font color=blue>Check</font></a> the whois information<br></td></tr>";
        	print   "</table><p>\n";
		
		print	"<table style=' margin:auto;'><tr><td>&nbsp;</td></tr>";
		print   "<tr><td>";
		print	"<form method=post action='whois.php?pid=$pid&domain=$domain&domain2=$ext&domainexist=no'>";
		print	"<font color='#12828e'>www.</font><input type=text name=domain size=30 class='domaintxt' > ";
		print	" <select size=1 name=ext class='domainselectfield'>";
		print	"<option selected value=com>.com</option>";
		print	"<option value=net>.net</option>";
		print	"<option value=org>.org</option>";
		print	"<option value=co.in>.co.in</option>";
		print 	"<option value=in>.in</option>\n</select> ";
		print	"<input type=hidden name=option value=check> ";
		print	"<input type=submit class='btn' value=Search></td></form>\n</td>\n</tr>\n</table>";
    }
     elseif($layout=="2"){
        $line++;
        print   "<table width=\"100%\" border=\"0\" cellPadding=2 class=font1l>\n";
        print 	"<tr>\n<td>\n<b>\n<center>Domain query Results for \"$domain.$ext\"</b>\n<br>\n</td>\n</tr>\n";
        print   "<tr>\n<td>\n<hr>\n</td>\n</tr>\n";
        print   "<tr>\n<td>\n<b><center>Could not contact the whois server $server</b>\n<br>\n</td>\n</tr>\n";
        print   "<tr>\n<td>\n<center>Check another domain name <a href=\"javascript:history.back()\">here</a>\n</td>\n</tr>\n";
        print   "</table>\n";
    }
    else{
    	  $line++;
        print   "<table width=\"100%\" border=\"0\" cellPadding=2 class=font1l>\n";
        print 	"<tr>\n<td>\n<b><center>Domain query Results for \"$domain.$ext\"</b>\n<br>\n</td>\n</tr>\n";
        print   "<tr>\n<td>\n<hr>\n</td>\n</tr>\n";
        print 	$layout;
        print   "<tr>\n<td>\n<center>Check another domain name <a href=\"javascript:history.back()\">here</a>\n</td>\n</tr>\n";
        print   "</table>\n";
    }
    print "<br>\n<br>\n";
    
    while ($line < $numtlines) {
	 echo $template[$line];
	 $line++;
   }
}

/*******		Function to print whois results	*****************************************/
function print_whois($output){
	global $template,$domain,$ext;
	if(!is_file($template)){
        print"The template file into which to print the results either does not exist
        or is not writable<br>
        please correct this if you are the webmaster of this site<br>
        The script can not continue exiting......";
        exit;
    }
    $template = file ($template);
    $numtlines = count ($template);
    $line = 0;
    while (! stristr ($template[$line], "<!--HEAVENS DOMAIN RESULTS-->") && $line < $numtlines) {
	echo $template[$line];
	$line++;
    }
    $line++;
    print   "<table width=\"100%\" border=\"0\" cellPadding=2 class=font1l>\n";
    print   "<tr>\n<td>\n<b>\n<center>\n Domain whois query information for \"$domain.$ext\"</b>\n</td>\n</tr>\n";
    print   "<tr>\n<td>\n<hr>\n</td>\n</tr>\n";
    print   "<tr>\n<td>\n";
    $output= explode("\n",$output);
    foreach ($output as $value){
            print "\n$value<br>\n";
    }
    print "</td>\n</tr>\n</table>\n";
    print "<br>";
    while ($line < $numtlines) {
	echo $template[$line];
	$line++;
   }

}
/******	This checks the name for invaild characters	*******************************/
function namecheck($domain)
{
    if($domain==""){$layout = "<tr>\n<td>\n<font color=\"red\">\n<center>You must enter a domain to be checked</font>\n<br>\n";
 	 print_results($layout);exit;}
    if(strlen($domain)< 3){$layout = "<tr>\n<td>\n<font color=\"red\">\n<center>The domain name $domain is too short</font>\n</td>\n</tr>\n"; print_results($layout);exit;}
    if(strlen($domain)>57){$layout = "<tr>\n<td>\n<font color=\"red\">\n<center>The domain name $domain is too long</font>\n</td>\n</tr>\n"; print_results($layout);exit;}
    if(@ereg("^-|-$",$domain)){$layout = "<tr>\n<td>\n<font color=\"red\">\n<center>Domains cannot begin or end with a hyphen</font>\n</td>\n</tr>\n"; print_results($layout);exit;}
    if(!ereg("([a-z]|[A-Z]|[0-9]|-){".strlen($domain)."}",$domain))
    {$layout = "<tr>\n<td>\n<font color=\"red\">\n<center>Domain names cannot contain special characters</font>\n</td>\n</tr>\n"; print_results($layout);exit;}

}
/*******	Function to check co.za whois via socket connection	*********************/
function cozacheck($domain){
		$errno = 0;
		$errostr = "";
		$timeout = 30;
		$fp = fsockopen("co.za",80,$errno,$errstr,$timeout);
		if($fp){
			socket_set_timeout($fp,$timeout);
			$url = "GET /cgi-bin/whois.sh?id=$id&Domain=$domain HTTP/1.0\r\n Host: co.za\r\n";
			$url .= "Connection: Keep-Alive\r\n User-Agent: Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.0; .NET CLR 1.0.3705)\r\n";
			$url .= "Referer: http://co.za/whois.shtml\r\n Accept: text/plain, text/html\r\n\r\n";
			fputs($fp,$url);
			$output = "";
			while(!feof($fp)){
				$output .= fgets($fp,128);	
			}
			fclose($fp);
			$temp_code = strip_tags($output); 
			if(eregi("Match: One",$temp_code)){
				//echo "The name is taken";
				return 1;
			}else{
				//echo "The name is available";
				return 0;
			}
		}else{
			$layout = "<tr>\n<td>\nThe script could not connect to the co.za whois server<br>";
			$layout .= "<b>DEBUG INFO:</b><br><br>";
			$layout .= "Error No: $errno<br>Error Description:<br>$errstr</td>\n</tr>\n";
			print_results($layout);
			exit;
		}

	}
/********	Function to check co.za whois via curl		***************************/
	function cozacurlcheck($domain){
		$ch = curl_init();
		$url = "http://co.za/cgi-bin/whois.sh?Domain=";
		$url .= $domain;
		curl_setopt($ch, CURLOPT_URL, $url);
		curl_setopt($ch, CURLOPT_FAILONERROR, 1);
		curl_setopt($ch, CURLOPT_USERAGENT, "Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.0; .NET CLR 1.0.3705)");
		curl_setopt($ch, CURLOPT_FOLLOWLOCATION, 0);
		curl_setopt($ch, CURLOPT_TIMEOUT, 4);
		curl_setopt($ch, CURLOPT_REFERER, "http://co.za/whois.shtml"); 
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        $data = curl_exec($ch);
		if(curl_error($ch) == ""){
			curl_close($ch); 
			$temp_code = strip_tags($data);
			if(eregi("Match: One",$temp_code)){
				//echo "The name is taken";
				return 1;
			}else{
				//echo "The name is available";
				return 0;
			}
		}else{
			curl_close($ch);
			$layout = "<tr>\n<td>\nAn Error Occured in connecting to the whois server</td>\n</tr>\n";
			print_results($layout);
			exit;
		}
	}
/**********		function to return whois record via socket	***********************/
	function cozawhois($domain){
		$errno = 0;
		$errostr = "";
		$timeout = 30;
		$fp = fsockopen("co.za",80,$errno,$errstr,$timeout);
		if($fp){
			socket_set_timeout($fp,$timeout);
			$url = "GET /cgi-bin/whois.sh?id=999&Domain=$domain HTTP/1.0\r\n Host: co.za\r\n";
			$url .= "Connection: Keep-Alive\r\n User-Agent: Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.0; .NET CLR 1.0.3705)\r\n";
			$url .= "Referer: http://co.za/whois.shtml\r\n Accept: text/plain, text/html\r\n\r\n";
			fputs($fp,$url);
			$output = "";
			while(!feof($fp)){
				$output .= fgets($fp,128);	
			}
			fclose($fp);
			$temp_code = strip_tags($output);
			$startp = strpos($temp_code,"The CO.ZA simple whois server");
			$dis = substr($temp_code,$startp);
			print_whois($dis);
		}else{
			$layout = "<tr>\n<td>\nThe script could not connect to the co.za whois server<br>";
			$layout.= "<b>DEBUG INFO:</b><br><br>";
			$layout.= "Error No: $errno<br>Error Description:<br>$errstr</td>\n</tr>\n";
			print_results($layout);
			exit;
		}
	}
/**********		function to return whois record via curl		**********************/
	function cozacurlwhois($domain){
		$ch = curl_init();
		$url = "http://co.za/cgi-bin/whois.sh?Domain=";
		$url .= $domain;
		curl_setopt($ch, CURLOPT_URL, $url);
		curl_setopt($ch, CURLOPT_FAILONERROR, 1);
		curl_setopt($ch, CURLOPT_USERAGENT, "Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.0; .NET CLR 1.0.3705)");
		curl_setopt($ch, CURLOPT_FOLLOWLOCATION, 0);
		curl_setopt($ch, CURLOPT_TIMEOUT, 4);
		curl_setopt($ch, CURLOPT_REFERER, "http://co.za/whois.shtml"); 
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        $data = curl_exec($ch);
		if(curl_error($ch) == ""){
			curl_close($ch); 
			$temp_code = strip_tags($data);
			$startp = strpos($temp_code,"The CO.ZA simple whois server");
			$dis = substr($temp_code,$startp);
			print_whois($dis);
		}else{
			curl_close($ch);
			$layout = "<tr>\n<td>\nAn Error Occured in connecting to the whois 		server</td>\n</tr>\n";
			print_results($layout);
			exit;
		}

	}
/***<--------------------------------end functions------------------------------------>***/